define(['angular', 'app', 'lodash', 'moment'], function (angular, app, lodash, moment) {
	'use strict';

	app.controller('HealthMoodEntryController', function ($scope, $state, $stateParams, $filter, HealthMoodConstants, HealthMoodService, MoodFeedbackService, HealthMoodRemindersService, modalService, focusService) {
		$scope.section = $stateParams.section;
		angular.extend($scope, HealthMoodConstants[$stateParams.section].entry);

		var service = HealthMoodService.instance($stateParams.section),
		moodFeedback = MoodFeedbackService;

		$scope.notificationDetails = {
			notificationStatus: ''
		};

		HealthMoodRemindersService.init($stateParams.section);
		HealthMoodRemindersService.getReminder().then(function (response) {
			$scope.notificationDetails = angular.copy(response);
		});

		$scope.entryForm = {
			service: service,
			callbacks: {
				common: function () {
					returnToSummary();
				},
				save : function() {
					if($stateParams.section === "mood") {
						showMoodFeedback($scope.details.valueQuantity.value);
					} else {
						returnToSummary();
					}
				}
			},
			allowedActions: {
				save: true,
				delete: !!$stateParams.id,
				cancel: true
			}
		};

		var returnToSummary = function() {
            $state.go($state.current.data.backState, $stateParams);
        };

		var showMoodFeedback = function(moodValue) {
	
			var message;
			if (moodValue<4 && moodValue) {
				message = moodFeedback.getLowMessage();
			} else if (moodValue > 6) {
				message = moodFeedback.getHighMessage();
			} else {
				message = moodFeedback.getMidMessage();
			}

			var modalOptions = {
				headerText : "Mood ",
				icon : message.icon,
				bodyText : message.text,
				actionButtonText: 'OK',
				centerBody : true
			}

			modalService.showModal({}, modalOptions).then(function() { $state.go($state.current.data.backState, $stateParams);}, function() {$state.go($state.current.data.backState, $stateParams);});
		}



		if($stateParams.section === "mood") {
			$scope.errorHandling = {
				'requiredMood': {
					message: "Mood field is required.",
					priority: 1
				}
			};

			$scope.$watch("[details.valueQuantity.value, form]", function () {
				if (angular.isDefined($scope.form) && angular.isDefined($scope.form.specialErrors)) {
					if ($scope.details.valueQuantity.value==="") {
						$scope.form.specialErrors.$setValidity("requiredMood", false);
					} else {
						$scope.form.specialErrors.$setValidity("requiredMood", true);
					}

					//$scope.form.specialErrors.$setValidity("requiredMood", $scope.details.valueQuantity.value);
				}
			}, true);

			$scope.openMoodModal = function () {
				var modalContent = {
					closeButtonText: 'Cancel',
					actionButtonText: 'OK',
					bodyContentUrl: 'src/modules/health-mood/pages/entry/partials/mood-modal_template.html',
					headerText: 'Select Mood',
					data: {value: $scope.details.valueQuantity.value || 5}
				};

				modalService.showModal({}, modalContent).then(function () {
					$scope.details.valueQuantity.value = modalContent.data.value;
					$scope.form.$setDirty();
				}).finally(function () {
					focusService.focusElement('button[ng-click="openMoodModal()"]');
					
				});
			};			
        };


		if ($stateParams.section === "cholesterol") {
			$scope.hidden = true;
			$scope.errorHandling = {
			    'Invalid-Date' : {
			        message : "An entry has already been saved with the same date. Please change your date and save again.",
			        priority : 1
			    },
			    'Lab-Result-Required' : {
			        message : "Provide at least one Lab Result value to save your entry.",
			        priority : 1
			    }
			};

			$scope.$watch("[details.entry, details.inputEntryDate, form]", function(newVal){
				if (angular.isDefined($scope.form) && angular.isDefined($scope.form.specialErrors)) {

					if($scope.details.inputEntryDate && $scope.details.inputEntryDate.length === 10 && $scope.form.specialErrors) {
					    var result = true;
					    for(var i = 0; i < service.dataPointers.unfilteredList.length; i++) {
					        if((moment(service.dataPointers.unfilteredList[i].updated, "MM/DD/YYYY").diff(moment($scope.details.inputEntryDate, "MM/DD/YYYY")) === 0) &&
					           (service.dataPointers.unfilteredList[i]._id !== $scope.details._id)){
					            result = false;
					            break;
					        }
					    } 
					    $scope.form.specialErrors.$setValidity("Invalid-Date", result);
					}		 			

					var validValue = false;
					if (newVal[0][0].valueQuantity.value || newVal[0][1].valueQuantity.value || newVal[0][2].valueQuantity.value || newVal[0][3].valueQuantity.value) {
						validValue = true;
					}

					$scope.form.specialErrors.$setValidity("Lab-Result-Required", validValue);

				}
			}, true);

		} else if ($stateParams.section === "bp-pulse") {
            $scope.errorHandling = {
                'Invalid-BP' : {
                    message : "The Systolic (mmHg) value must be greater than the Diastolic (mmHg) value. Please check the values and re-enter.",
                    priority : 1
                },
				'Lab-Result-Required' : {
					message : "Provide either both blood pressure values or a pulse value to save.",
					priority : 1
				},
				'BP-Required' : {
					message : "Both Systolic and Diastolic values are required to save a blood pressure reading.",
					priority : 1
				}
            };

            $scope.$watch("[details.entry[0].valueQuantity.value, details.entry[1].valueQuantity.value, details.entry[2].valueQuantity.value, form]", function(curVal){
				if ($scope.form && $scope.form.specialErrors) {
					var systolic=false,diastolic=false,pulse=false;
					if (curVal[0]) systolic=true;
					if (curVal[1]) diastolic=true;
					if (curVal[2]) pulse=true;

					//If BP entered, make sure both systolic & diastolic are there
					if ((systolic && !diastolic) || (diastolic && !systolic)) {
						$scope.form.specialErrors.$setValidity("BP-Required",false);
					} else {
						$scope.form.specialErrors.$setValidity("BP-Required",true);
					}

					//if BP entered, make sure systolic > diastolic
					if (systolic && diastolic && parseInt(curVal[0])<=parseInt(curVal[1])) {
						$scope.form.specialErrors.$setValidity("Invalid-BP",false);
					} else {
						$scope.form.specialErrors.$setValidity("Invalid-BP",true);
					}

					//one of the entries are required
					if (!systolic && !diastolic && !pulse) {
						$scope.form.specialErrors.$setValidity("Lab-Result-Required",false);
					} else {
						$scope.form.specialErrors.$setValidity("Lab-Result-Required",true);
					}
				}
            }, true);
        }
		
		$scope.allowedDateRange = { min: moment().subtract(6, 'year').format('L') };
		$scope.sectionTitle = $filter('filter')($state.current.data.paramSections, { paramValue: $stateParams.section }, true)[0].sectionName;
		$scope.details = $stateParams.id ? angular.copy(service.localGetById($stateParams.id)) : service.createEmpty();
	});
});